//--------------------------------------------------------------
// IIR フィルタ，縦続形，float で演算, Biquad クラス利用
//      Analog Input : A0
//      Analog Output: MCP4922 using SPI
// 2015/07/03, Copyright (c) 2015 MIKAMI, Naoki
//--------------------------------------------------------------

#include "ADC_BuiltIn.hpp"      // for ADC not using interrupt
#include "DAC_MCP4921.hpp"      // for DAC MCP4921, MCP4922
#include "Biquad.hpp"           // 2nd-ordered IIR filter

using namespace Mikami;

const int ORDER_ = 6;   // order

// 低域通過フィルタ
// 連立チェビシェフ特性
// 次数　　　　：6 次
// 標本化周波数： 12.00 kHz
// 遮断周波数　：  0.40 kHz
// 通過域のリップル： 0.50 dB
// 阻止域の減衰量　：40.00 dB
const Biquad::Coefs ck_[ORDER_/2] = {
    {  1.837790E+00f, -8.507293E-01f, -1.603320E+00f,  1.0E+00f},  // 1段目
    {  1.904445E+00f, -9.382561E-01f, -1.919647E+00f,  1.0E+00f},  // 2段目
    {  1.942552E+00f, -9.865720E-01f, -1.942961E+00f,  1.0E+00f}}; // 3段目
const float g0_ = 1.000028E-02f;    // 利得定数

const int FS_ = 12000;      // Sampling frequency: 12 kHz
ADC_BuiltIn adc_(A0, FS_);  // for AD
DAC_MCP4921 myDac_;         // for DA

int main()
{
    myDac_.ScfClockTim3(500000);    // cutoff frequency: 5 kHz

    Biquad hn[ORDER_/2];
    for (int k=0; k<ORDER_/2; k++)
        hn[k] = Biquad(ck_[k]);

    while (true)
    {
        float xn = adc_.Read();     // Read from A0
        //-----------------------------------------------

        float yn = g0_*xn;
        for (int k=0; k<ORDER_/2; k++)
            yn = hn[k].Execute(yn);

        //-----------------------------------------------
        myDac_.Write(yn);    // Write to DAC
    }
}


