//--------------------------------------------------------------
// IIR フィルタ，縦続形，float で演算
//      Analog Input : A0
//      Analog Output: MCP4922 using SPI
// 2014/11/20, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"

#include "ADC_Base.hpp"         // for ADC not using interrupt
#include "DAC_MCP4922.hpp"      // for DAC MCP4922

using namespace Mikami;

const int ORDER_ = 6;   // order
struct Un { float u1, u2; };
struct Coefs { float a1, a2, b1, b2; };

// 低域通過フィルタ
// 連立チェビシェフ特性
// 次数　　　　：6 次
// 標本化周波数： 12.00 kHz
// 遮断周波数　：  0.40 kHz
// 通過域のリップル： 0.50 dB
// 阻止域の減衰量　：40.00 dB
const Coefs ck_[ORDER_/2] = {
    {  1.837790E+00f, -8.507293E-01f, -1.603320E+00f,  1.000000E+00f},  // 1段目
    {  1.904445E+00f, -9.382561E-01f, -1.919647E+00f,  1.000000E+00f},  // 2段目
    {  1.942552E+00f, -9.865720E-01f, -1.942961E+00f,  1.000000E+00f}}; // 3段目
const float g0_ = 1.000028E-02f;    // 利得定数

const int FS_ = 12000;  // Sampling frequency: 12 kHz
ADC_Base adc_(A0, FS_); // for AD
DAC_MCP4922 myDac_;     // for DA

int main()
{
    myDac_.ScfClockTim3(500000);    // cutoff frequency: 5 kHz

    Un uk[ORDER_/2];                // 過去の計算結果を格納する配列
    // 過去の入力信号が格納される配列をクリア
    for (int k=0; k<ORDER_/2; k++)
    {
        uk[k].u1 = 0;
        uk[k].u2 = 0;
    }

    while (true)
    {
        float xn = adc_.Read();     // Read from A0
        //-----------------------------------------------

        float yn = g0_*xn;
        for (int k=0; k<ORDER_/2; k++)
        {
            float un = ck_[k].a1*uk[k].u1 + ck_[k].a2*uk[k].u2 + yn;
            yn = un + ck_[k].b1*uk[k].u1 + ck_[k].b2*uk[k].u2;
            // 計算結果の移動
            uk[k].u2 = uk[k].u1;
            uk[k].u1 = un;
        }

        //-----------------------------------------------
        myDac_.Write(yn);    // Write to DAC
    }
}


