//------------------------------------------------------------------------------
//  縦続形 IIR フィルタのクラス
//  2015/03/16, Copyright (c) 2015 MIKAMI, Naoki
//------------------------------------------------------------------------------

#ifndef IIR_CASCADE_HPP
#define IIR_CASCADE_HPP

#include "Biquad.hpp"

namespace Mikami
{
    template<int order> class IIR_Cascade
    {
    public:
    
        // コンストラクタ
        IIR_Cascade(const Biquad::Coefs ck[], float g0) : g0_(g0) 
        {
            for (int n=0; n<order/2; n++)
                hk_[n] = new Biquad(ck[n]);
            Clear();
        }
    
//        ~IIR_Cascade() { delete[] hk_; }
        
        // 過去の計算結果を格納する配列のクリア
        void Clear()
        {
            for (int k=0; k<order/2; k++) hk_[k]->Clear();
        }

        // フィルタ処理の実行
        float Execute(float xn)
        {
            float yn = g0_*xn;
            for (int k=0; k<order/2; k++) yn = hk_[k]->Execute(yn);
            return yn;
        }

    private:
        Biquad* hk_[order/2];   // 2 次の IIR フィルタ
        const float g0_;        // 利得定数
    };
}
/*
template<int order> class IIR_Cascade
{
public:
    struct Coefs { float a1, a2, b1, b2; }; // フィルタ係数のための構造体
    
    // コンストラクタ
    IIR_Cascade(const Coefs ck[], float g0) : ck_(ck), g0_(g0) 
    {
        Clear();
    }
    
    // 過去の計算結果を格納する配列のクリア
    void Clear()
    {
        for (int k=0; k<order/2; k++)  // 過去の入力信号が格納される配列をクリア
        {
            uk_[k].u1 = 0;
            uk_[k].u2 = 0;
        }
    }

    // フィルタ処理の実行
    float Execute(float xn)
    {
        float yn = g0_*xn;
        for (int k=0; k<order/2; k++)
        {
            // 差分方程式に対応する計算
            float un = ck_[k].a1*uk_[k].u1 + ck_[k].a2*uk_[k].u2 + yn;
            yn = un + ck_[k].b1*uk_[k].u1 + ck_[k].b2*uk_[k].u2;
            // 計算結果の移動
            uk_[k].u2 = uk_[k].u1;
            uk_[k].u1 = un;
        }
        return yn;
    }

private:
    struct Un { float u1, u2; };    // 過去の計算結果格納のための構造体
    Un uk_[order/2];                // 過去の計算結果を格納する配列
    const Coefs *const ck_;         // フィルタの係数
    const float g0_;                // 利得定数
};
*/
#endif  // IIR_CASCADE_HPP 
