//--------------------------------------------------------------
// Biquad filter for IIR filter of cascade structure
// 2014/10/21, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef IIR_BIQUAD_HPP
#define IIR_BIQUAD_HPP

#include "mbed.h"

// 2nd order IIR filter
namespace Mikami
{
    class Biquad
    {
    public:
        struct Coefs { float a1, a2, b1, b2; };

        Biquad() {}     // Default constructore

        Biquad(const Coefs ck)
              : a1_(ck.a1), a2_(ck.a2), b1_(ck.b1), b2_(ck.b2)
        { Clear(); }       

        float Execute(float xn)
        {
            float un = xn + a1_*un1_ + a2_*un2_;
            float yn = un + b1_*un1_ + b2_*un2_;
    
            un2_ = un1_;
            un1_ = un;

            return yn;
        }

        void Clear() { un1_ = un2_ = 0; }

    private:
        float a1_, a2_, b1_, b2_;
        float un1_, un2_;

        Biquad(const Biquad&);
};
}
#endif  // IIR_BIQUAD_HPP



