//--------------------------------------------------------------
//  Weaver 変調器を使う周波数シフタで使っているフィルタの係数
//--------------------------------------------------------------
#include "Biquad.hpp"

using namespace Mikami;

//--------------------------------------------------------------
// 入力帯域制限用帯域通過フィルタの係数
//--------------------------------------------------------------
// 帯域通過フィルタ
// 連立チェビシェフ特性
// 次数　　　　：12 次
// 標本化周波数： 10.00 kHz
// 遮断周波数１：  0.20 kHz
// 遮断周波数２：  4.20 kHz
// 通過域のリップル： 0.50 dB
// 阻止域の減衰量　：60.00 dB
const int ORDER_BPF_ = 12;   // 次数
const Biquad::Coefs ckBP_[ORDER_BPF_/2] = {
    {-6.875894E-01f, -2.860100E-01f,  1.987324E+00f,  1.0f},    // 1段目
    { 1.642483E+00f, -7.033978E-01f, -1.999237E+00f,  1.0f},    // 2段目
    {-1.476697E+00f, -7.844624E-01f,  1.920831E+00f,  1.0f},    // 3段目
    { 1.915760E+00f, -9.375948E-01f, -1.995156E+00f,  1.0f},    // 4段目
    {-1.715001E+00f, -9.524712E-01f,  1.874031E+00f,  1.0f},    // 5段目
    { 1.972033E+00f, -9.874265E-01f, -1.992206E+00f,  1.0f} };  // 6段目
const float g0Bpf_ = 2.768857E-01f;    // 利得定数

//--------------------------------------------------------------
// Weaver 変調器で使う低域通過フィルタの係数
//--------------------------------------------------------------
// 低域通過フィルタ
// 連立チェビシェフ特性
// 次数　　　　：8 次
// 標本化周波数： 10.00 kHz
// 遮断周波数　：  2.30 kHz
// 通過域のリップル： 0.50 dB
// 阻止域の減衰量　：60.00 dB
const int ORDER_LPF_ = 8;   // 次数
const Biquad::Coefs ckLP_[ORDER_LPF_/2] = {
    { 1.029119E+00f, -3.631409E-01f,  1.717298E+00f,  1.0f},    // 1段目
    { 6.358165E-01f, -6.464544E-01f,  6.744049E-01f,  1.0f},    // 2段目
    { 3.499033E-01f, -8.594617E-01f,  1.627564E-01f,  1.0f},    // 3段目
    { 2.400248E-01f, -9.645248E-01f, -1.001503E-03f,  1.0f} };  // 4段目
const float g0Lpf_ = 1.930230E-02f;    // 利得定数

