//--------------------------------------------------------------
// Frequency shifter using analytic signal
//      Frequency is shifted toward 100 Hz higher
//      sw number = even : No frequency shift
//      sw number = odd  : Frequency shift

// 2015/07/25, Copyright (c) 2015 MIKAMI, Naoki
//--------------------------------------------------------------

#include "ADC_BuiltIn.hpp"      // for ADC not using interrupt
#include "DAC_MCP4921.hpp"      // for DAC MCP4921, MCP4922

#include "HilbertTransform.hpp"     // Hilbert transform filter
#include "coefsHilbert114.hpp"      // Coeffisients of Hilbert transform filter
#include "DC_Cut_Coefficients.hpp"  // Coeffisients of DC-cut filter
#include "Biquad.hpp"               // For DC-cut filter
#include "TwoPhaseGenerator.hpp"    // Two-phase generator

using namespace Mikami;

const int FS_ = 12000;  // 12 kHz
ADC_BuiltIn adc_(A0, FS_);
DAC_MCP4921 myDac_;
DigitalIn sw_(D2, PullDown);

Hilbert<ORDER_> ht_(hm_);   // Hilbert transform filter
Biquad DcCut_(c1_);         // DC cut filter
TwoPhaseGenerator cosSin_(100, (float)FS_); // 100 Hz

int main()
{
    myDac_.ScfClockTim3(500000);    // cutoff frequency: 5 kHz

    while (true)
    {
        float xn = adc_.Read();         // Read from A0
        //-----------------------------------------------

        xn = DcCut_.Execute(g0_*xn);    // DC cut filter
        float yIn, yQn;
        ht_.Execute(xn, yIn, yQn);      // Hilbert transform filter
        float cos, sin;
        cosSin_.Generate(cos, sin);     // cos and sin
        float yn = yIn*cos - yQn*sin;
        
        if (sw_.read() == 0) yn = xn;   // no frequency shift
        //-----------------------------------------------
        myDac_.Write(yn);               // Write to DAC  
    }
}
