//--------------------------------------------------------------
// FIR フィルタ，転置形
//      Analog Input : A0
//      Analog Output: MCP4922 using SPI
// 2014/11/12, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"

#include "ADC_Base.hpp"         // for ADC not using interrupt
#include "DAC_MCP4922.hpp"      // for DAC MCP4922
#include "Coefficients_200_LPF.hpp"

using namespace Mikami;

const int FS_ = 12000;  // Sampling frequency: 12 kHz
ADC_Base adc_(A0, FS_); // for AD
DAC_MCP4922 myDac_;     // for DA

int main()
{
    myDac_.ScfClockTim3(500000);    // cutoff frequency: 5 kHz

    float un[ORDER_+1];
    for (int n=0; n<=ORDER_; n++)
        un[n] = 0;
    
    while (true)
    {
        float xn = adc_.Read(); // Read from A0
        //-----------------------------------------------

        for (int k=0; k<ORDER_; k++)
            un[k] = hm_[k]*xn + un[k+1];
        un[ORDER_] = hm_[ORDER_]*xn;

        //-----------------------------------------------
        myDac_.Write(un[0]);    // Write to DAC
    }
}
