//--------------------------------------------------------------
// FIR フィルタ，係数の対称性を利用する構造
//      Analog Input : A0
//      Analog Output: MCP4922 using SPI
// 2014/11/12, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"

#include "ADC_Base.hpp"         // for ADC not using interrupt
#include "DAC_MCP4922.hpp"      // for DAC MCP4922
#include "Coefficients_200_LPF_Sym.hpp"

using namespace Mikami;

const int FS_ = 12000;  // Sampling frequency: 12 kHz
ADC_Base adc_(A0, FS_); // for AD
DAC_MCP4922 myDac_;     // for DA

int main()
{
    myDac_.ScfClockTim3(500000);    // cutoff frequency: 5 kHz

    float xn[ORDER_+1];
    for (int n=0; n<=ORDER_; n++)
        xn[n] = 0;
    
    while (true)
    {
        xn[0] = adc_.Read();     // Read from A0
        //-----------------------------------------------

        float yn = hm_[ORDER_/2]*xn[ORDER_/2];
        for (int k=0; k<ORDER_/2; k++)
            yn = yn + hm_[k]*(xn[k] + xn[ORDER_-k]);

        for (int k=ORDER_; k>0; k--)
            xn[k] = xn[k-1];  // move input signals

        //-----------------------------------------------
        myDac_.Write(yn);    // Write to DAC
    }
}
