//--------------------------------------------------------------
// FIR フィルタ，基本的な構造
//      Analog Input : A0
//      Analog Output: MCP4922 using SPI
// 2015/07/03, Copyright (c) 2015 MIKAMI, Naoki
//--------------------------------------------------------------

#include "ADC_BuiltIn.hpp"      // for ADC not using interrupt
#include "DAC_MCP4921.hpp"      // for DAC MCP4921, MCP4922
#include "Coefficients_200_LPF.hpp"

using namespace Mikami;

const int FS_ = 12000;      // Sampling frequency: 12 kHz
ADC_BuiltIn adc_(A0, FS_);  // for AD
DAC_MCP4921 myDac_;         // for DA

int main()
{
    myDac_.ScfClockTim3(500000);    // cutoff frequency: 5 kHz

    float xn[ORDER_+1];
    for (int n=0; n<=ORDER_; n++)
        xn[n] = 0;
    
    while (true)
    {
        xn[0] = adc_.Read();    // Read from A0
        //-----------------------------------------------

        float yn = 0;
        for (int k=0; k<=ORDER_; k++)
            yn = yn + hm_[k]*xn[k];

        for (int k=ORDER_; k>0; k--)
            xn[k] = xn[k-1];    // move input signals

        //-----------------------------------------------
        myDac_.Write(yn);       // Write to DAC
    }
}
