//------------------------------------------------------------------------------
//  cos波，sin波の同時発生，2次の IIR フィルタを使う方法
//  アルゴリズム検証用プログラムのため，無駄な部分あり
//  2016/02/23, Copyright (c) 2016 MIKAMI, Naoki
//------------------------------------------------------------------------------

#include "ADC_BuiltIn.hpp"      // かならず必要
#include "DAC_MCP4922Dual.hpp"  // DAC MCP4922，２チャンネル用

using namespace Mikami;         //　かならず必要

const int FS_ = 10000;          // 標本化周波数: 10 kHz
ADC_BuiltIn adc_(A0, FS_);      // A0 からの入力を使うように設定
DAC_MCP4922Dual myDac_;         // DAC を２チャンネルで使うための設定

int main()
{
    myDac_.ScfClockTim3(420000);    // 出力の LPF の遮断周波数を 4.2 kHz に設定

    const float F0 = 440;           // 発生する sin, con の周波数
    const float PI2FT = 6.28319f*F0/(float)FS_;
    const float a1 = 2.0f*cosf(PI2FT);
    const float b1S = sinf(PI2FT);
    const float b1C = cosf(PI2FT);

    float un1 = 0;  // u[-1] = 0;
    float un2 = 0;  // u[-2] = 0;
    float xn  = 1;  // x[n], 単位インパルス
    while (true)
    {
        adc_.Read();    // 標本化クロックと同期をとるために必要
        //-----------------------------------------------
        float un = a1*un1 - un2  + xn;
        
        float ynS = un1*b1S;        // sin
        float ynC = un - un1*b1C;   // cos
        
        un2 = un1;
        un1 = un;

        xn = 0;         // 単位インパルスなので次からは 0
        //-----------------------------------------------
        myDac_.Write(0.8f*ynS, 0.8f*ynC);   // DAC へ出力する
    }
}
//------------------------------------------------------------------------------
