//--------------------------------------------------------------
// Reverb system using comb filter
// 2014/11/12, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"

#include "ADC_Base.hpp"         // for ADC not using interrupt
#include "DAC_MCP4922.hpp"      // for DAC MCP4922

using namespace Mikami;

const int FS_ = 12000;  // Sampling frequency: 12 kHz
ADC_Base adc_(A0, FS_); // for AD
DAC_MCP4922 myDac_;     // for DA

const float G_C_ = 0.8f;
const float G0_ = 2.0f*(1.0f - G_C_);
const int M1 = 1153;
float ynD[M1];

DigitalIn sw_(D2, PullDown);

int main()
{
    myDac_.ScfClockTim3(500000);    // cutoff frequency: 5 kHz

    for (int n=0; n<M1; n++) ynD[n] = 0.0f;
    int nD = 0;
    
    while (true)
    {
        float xn = adc_.Read(); // Read from A0
        //-----------------------------------------------

        float yn;
        if (sw_.read() == 1)
        {
            yn = ynD[nD];
            ynD[nD++] = G0_*xn + G_C_*yn;
            if (nD >= M1) nD = 0;
        }
        else
            yn = xn;

        //-----------------------------------------------
        myDac_.Write(yn);       // Write to DAC
    }
}
