//--------------------------------------------------------------
// Reverb system using all-pass filter
// 2014/11/12, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"

#include "ADC_Base.hpp"         // for ADC not using interrupt
#include "DAC_MCP4922.hpp"      // for DAC MCP4922

using namespace Mikami;

const int FS_ = 12000;  // Sampling frequency: 12 kHz
ADC_Base adc_(A0, FS_); // for AD
DAC_MCP4922 myDac_;     // for DA

const float G_A_ = 0.6f;
const int M1 = 1153;
float unD[M1];

DigitalIn sw_(D2, PullDown);

int main()
{
    myDac_.ScfClockTim3(500000);    // cutoff frequency: 5 kHz

    for (int n=0; n<M1; n++) unD[n] = 0.0f;
    int nD = 0;

    while (true)
    {
        float xn = adc_.Read(); // Read from A0
        //-----------------------------------------------

        float yn;
        if (sw_.read() == 1)
        {
            float un = xn + G_A_*unD[nD];
            yn = -G_A_*un + unD[nD];
            unD[nD++] = un;
            if (nD >= M1) nD = 0;
        }
        else
            yn = xn;

        //-----------------------------------------------
        myDac_.Write(yn);       // Write to DAC
    }
}
