//--------------------------------------------------------------
// Adaptive line enhancer (ALE) by FIR filter using
// LMS algorithm
//      Analog Input : A0
//      Analog Output: MCP4922 using SPI
// 2014/11/15, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"

#include "ADC_Base.hpp"         // for ADC not using interrupt
#include "DAC_MCP4922.hpp"      // for DAC MCP4922

using namespace Mikami;

const int FS_ = 16000;  // Sampling frequency: 16 kHz
ADC_Base adc_(A0, FS_); // for AD
DAC_MCP4922 myDac_;     // for DA
DigitalIn sw_(D2, PullDown);

int main()
{
    myDac_.ScfClockTim3(500000);    // cutoff frequency: 5 kHz

    const int ORDER = 100;      // Order of FIR filter
    const int DELAY = 5;        // Number of delay to reduce correlation
    const int N_ALL = ORDER + DELAY + 1;
    const float MU = 1.0e-4f;   // Step size parameter
    
    float xn[N_ALL], hm[ORDER+1];
    
    for (int n=0; n<N_ALL; n++) xn[n] = 0;
    for (int n=0; n<=ORDER; n++) hm[n] = 0;
    
    while (true)
    {
        xn[0] = adc_.Read();    // Read from A0
        //-----------------------------------------------

        // Execute FIR filter
        float yn = 0;
        for (int k=0; k<=ORDER; k++)
            yn = yn + hm[k]*xn[k+DELAY];

        // Update ceefficients
        float err_mu = (xn[0] - yn)*MU;
        for (int k=0; k<=ORDER; k++)
            hm[k] = hm[k] + err_mu*xn[k+DELAY];
        
        // Move input signal in delays
        for (int k=N_ALL-1; k>0; k--)
            xn[k] = xn[k-1];    // move input signals

        if (sw_.read() == 0) yn = xn[0];   // no ALE
        //-----------------------------------------------
        myDac_.Write(yn);       // Write to DAC
    }
}
