//------------------------------------------------------------
//  Sinple DAC class using SPI interface
//      DAC: MCP4922, using only channel A (VOUTA)
//------------------------------------------------------------

class DacA
{
public:
    // Constructor
    DacA()
    : mySpi_(SPI_MOSI, NC, SPI_SCK),    // D11, NC, D13
      myCs_(SPI_CS, 1),                 // D10, CS <= H
      myLd_(D12, 0)                     // D12, LDAC <= L
    {
        // Set SPI format and bus frequency
        mySpi_.format(16, 0);
        mySpi_.frequency(20000000); // SPI clock: 20 MHz
    }

    // 0 <= value <= 4095
    void Write(uint16_t value)
    {
        myCs_.write(0); // cs <= L
        mySpi_.write(value | 0x3000);
        myCs_.write(1); // cs <= H
    }

private:
    SPI mySpi_;       // SPI object
    DigitalOut myCs_; // for chip select
    DigitalOut myLd_; // for LDAC
};
