//--------------------------------------------------------------
// Example for ADC and DAC using mbed official classes
// Copyright (c) 2014 MIKAMI, Naoki, 2014/11/05
//--------------------------------------------------------------

#include "mbed.h"
#include "myDac.hpp"

AnalogIn adc_(A0);  // using mbed official class
DacA dacA_;         // using hand made class

Ticker timer_;      // for timer interrupt

// Timer interrupt service routine
void TimerIsr()
{
    uint16_t value = adc_.read_u16();   // AD
    dacA_.Write(value>>4);              // DA
}

int main()
{
    timer_.attach_us(&TimerIsr, 20);
    while (true) {}
}


