//---------------------------------------------------------------------
//  スペクトル解析の結果を PC へ転送するための XferBase の派生クラス
//
//  2021/07/11, Copyright (c) 2021 MIKAMI, Naoki
//---------------------------------------------------------------------

#include "XferBase.hpp"

#ifndef XFER_SPECTRUM_DERIVED_HPP
#define XFER_SPECTRUM_DERIVED_HPP

class XferSpectrum : public XferBase
{
public:
    // コンストラクタ
    XferSpectrum(SerialRxTxIntr& rxTx, int size)
        : XferBase(rxTx, size) {}

private:
    // スペクトル解析の結果を転送する形式に変換
    //      yAbs    FFT の結果の絶対値
    virtual void Convert(const float yAbs[])
    {
        const float MAX = 10000;
        for (int n=0; n<SIZE_; n++)
        {
            float x = yAbs[n];
            xn_[n] = (x > MAX) ? (uint16_t)MAX : (uint16_t)x; 
        }
    }
    
    // コピー･コンストラクタおよび代入演算子の禁止のため
    XferSpectrum(const XferSpectrum&);
    XferSpectrum& operator=(const XferSpectrum&);
};
#endif  // XFER_SPECTRUM_DERIVED_HPP