//---------------------------------------------------------------------
//  データを PC へ転送するための抽象基底クラス
//
//  2021/07/11, Copyright (c) 2021 MIKAMI, Naoki
//---------------------------------------------------------------------

#include <string>
#include "SerialRxTxIntr.hpp"
using namespace Mikami;

#ifndef XFER_ABSTRACT_BASE_HPP
#define XFER_ABSTRACT_BASE_HPP

class XferBase
{
public:
    // コンストラクタ
    XferBase(SerialRxTxIntr& rxTx, int size)
        : SIZE_(size), xn_(size), rxTx_(rxTx) {}

    // データを PC へ転送（0 ～ 10,000 の範囲の値を 2 文字で表すコード化を利用）
    void ToPC(const float data[])
    {
        Convert(data);
        string str = "";
        for (int n=0; n<SIZE_; n++)
        {
            str += ((xn_[n] >> 7) & 0x7F) + 0x10;
            str += (xn_[n] & 0x7F) + 0x10;
        }
        rxTx_.TxString(str+"\n");
    }

protected:
    const int SIZE_;        // PC に送るデータの数
    Array<uint16_t> xn_;    // PC に送るデータ

private:
    SerialRxTxIntr& rxTx_;

    // データを転送する際の形式に変換
    //      data    元のデータ
    virtual void Convert(const float data[]) = 0;

    // コピー･コンストラクタおよび代入演算子の禁止のため
    XferBase(const XferBase&);
    XferBase& operator=(const XferBase&);
};
#endif  // XFER_ABSTRACT_BASE_HPP