//-------------------------------------------------------
//  スペクトログラムで使う FFT 解析用クラス（ヘッダ）
//
//  2021/11/17, Copyright (c) 2021 MIKAMI, Naoki
//-------------------------------------------------------

#ifndef FFT_ANALYZER_HPP
#define FFT_ANALYZER_HPP

#include "Array.hpp"
#include "fftReal.hpp"
#include "Hamming.hpp"

namespace Mikami
{
    class FftSpectropgram
    {
    public:
        // nFft:  FFT のデータ点の数
        explicit FftSpectropgram(int nFft);
        virtual ~FftSpectropgram() {}
        void Execute(const Array<float> &xn, Array<float> &absFt);

        // データのコピーを行う際の高域強調の有無切り替え
        void SwEmphasis(bool on)
        {   fp = on ? &FftSpectropgram::CopyH : &FftSpectropgram::Copy; }

    private:
        const int N_FFT_;

        FftReal fft_;
        HammingWindow wHm_;     // ハミング窓

        Array<float> xData_;    // 解析対象の時系列データ
        Array<float> wData_;    // 窓掛けされたデータ
        Array<Complex> yFft_;   // FFT の結果

        // コピーの際に使う関数に対する関数ポインタ
        void (FftSpectropgram::*fp)(const Array<float> &xn);
        // データを作業領域にコピー：高域強調は行わない
        void Copy(const Array<float> &xn) { xData_ = xn; }
        // データを作業領域にコピー：高域強調は行う
        void CopyH(const Array<float> &xn);

        // コピー･コンストラクタおよび代入演算子の禁止のため
        FftSpectropgram(const FftSpectropgram& );
        FftSpectropgram& operator=(const FftSpectropgram& );
    };
}
#endif  // FFT_ANALYZER_HPP