//-------------------------------------------------------
//  スペクトログラムで使う FFT 解析用クラス
//
//  2021/11/17, Copyright (c) 2021 MIKAMI, Naoki
//-------------------------------------------------------

#include "FFT_Spectrogram.hpp"

namespace Mikami
{
    FftSpectropgram::FftSpectropgram(int nFft)
        : N_FFT_(nFft), fft_(nFft), wHm_(nFft),
          xData_(nFft), wData_(nFft), yFft_(nFft/2+1)
    { SwEmphasis(false); }	 // 最初は高域強調なし

    void FftSpectropgram::Execute(const Array<float> &xn,
    							  Array<float> &absFt)
    {
		// データのコピー，高域強調の有無は SwEmphasis() で切り替え
		(this->*fp)(xn);

        // 直流分を除去
        float sum = 0;
        for (int n=0; n<N_FFT_; n++) sum = sum + xData_[n];
        float ave = sum/N_FFT_;
        for (int n=0; n<N_FFT_; n++) xData_[n] = xData_[n] - ave;

        wData_ = wHm_.Execute(xData_);  // 窓掛け
        fft_.Execute(wData_, yFft_);    // FFT の実行
        for (int n=0; n<=N_FFT_/2; n++) // 絶対値に変換
            absFt[n] = 100.0f*abs(yFft_[n]);
    }

    // データを作業領域にコピーする際に高域強調処理を行う
    void FftSpectropgram::CopyH(const Array<float> &xn)
    {
        // 差分の処理
        for (int n=1; n<N_FFT_; n++)	// n=1 から開始
            xData_[n] = xn[n] - xn[n-1];
		xData_[0] = xData_[1];			// n=0 に対応
    }
}