//-----------------------------------------------------
//  縦続形 IIR フィルタの次数と係数の定義
//
//  2021/06/01, Copyright (c) 2021 MIKAMI, Naoki
//-----------------------------------------------------

#include "Biquad.hpp"

// FFT アナライザで使うフィルタ
//      標本化周波数が 102.4 kHz の場合，5.24 kHz 以上で
//      少なくとも 60 dB 減衰させる LPF

// 低域通過フィルタ
// 連立チェビシェフ特性
// 次数　　　　： 10 次
// 標本化周波数：102.4000 kHz
// 遮断周波数　：  5.0000 kHz
// 通過域のリップル： 0.50 dB
// 阻止域の減衰量　：60.00 dB

const int ORDER1_ = 10;
const Biquad::Coefs CK1_[] = {
    { 1.820963E+00f, -8.355312E-01f, -9.111580E-01f, 1.0f},  // 1段目
    { 1.853721E+00f, -9.012503E-01f, -1.783341E+00f, 1.0f},  // 2段目
    { 1.881627E+00f, -9.570190E-01f, -1.871513E+00f, 1.0f},  // 3段目
    { 1.895648E+00f, -9.843304E-01f, -1.892515E+00f, 1.0f},  // 4段目
    { 1.902771E+00f, -9.961831E-01f, -1.898312E+00f, 1.0f}}; // 5段目
const float G01_ = 1.232249E-03f;    // 利得定数