//------------------------------------------------------------------------------
//  Nucleo-F446 と PC 間の通信を利用するプログラムの例
//  マイコンボード上の LED の点滅のコントロール：起動時は点灯状態
//      パソコンへデータを送信する際の終端コードは '\n'
//
//  2021/07/04, Copyright (c) 2021 MIKAMI, Naoki
//------------------------------------------------------------------------------

#include "SerialRxTxIntr.hpp"
using namespace Mikami;

int main()
{
    DigitalOut myLed(LED1, 1);  // LED に対応する出力ポート
    SerialRxTxIntr rxTx;        // PC との通信用，ボーレート：9600 baud
    bool blinking = false;

    while (true)
    {
        // 受信バッファのデータが有効であれば，送信された指令に対応する処理を行う
        if (rxTx.IsEol())
        {
            string str = rxTx.GetBuffer();  // 受信データ

            // "LED_CTRLer" の受信に対して "ACK" を送信
            if (str == "LED_CTRLer")
                rxTx.TxString("ACK\n");
            else    // "LED CTRLer" 以外の受信に対する処理
            {
                if (str == "ON")  blinking = true;
                if (str == "OFF") blinking = false;
                
                rxTx.TxString(str + "\n");  // 受信した文字列をそのまま送信
            }
        }
        if (blinking)
        {
            myLed = !myLed; // LED の点灯/消灯の切り替え
            wait(0.1);      // 0.1秒のウェイト
        }
    }
}