//---------------------------------------------------------------------
//  波形データを PC へ転送するための XferBase の派生クラス
//
//  2021/07/11, Copyright (c) 2021 MIKAMI, Naoki
//---------------------------------------------------------------------

#include "XferBase.hpp"

#ifndef XFER_WAVEFORM_DERIVED_HPP
#define XFER_WAVEFORM_DERIVED_HPP

class XferWaveform : public XferBase
{
public:
    // コンストラクタ
    XferWaveform(SerialRxTxIntr& rxTx, int size)
        : XferBase(rxTx, size) {}

private:
    // 転送すべきデータを転送する形式に変換
    //      -1 <= xIn[] <= 1
    //      対応関係：1 => 10000, -1 => 0
    virtual void Convert(const float xIn[])
    {
        static const float FACTOR = 5000.0f;
        for (int n=0; n<SIZE_; n++)
        {
            float x = FACTOR*(xIn[n] + 1.0f);
            if (x > 10000) x = 10000;
            if (x < 0) x = 0;
            xn_[n] = (uint16_t)x;
        }
    }

    // コピー･コンストラクタおよび代入演算子の禁止のため
    XferWaveform(const XferWaveform&);
    XferWaveform& operator=(const XferWaveform&);
};
#endif  // XFER_WAVEFORM_DERIVED_HPP