//--------------------------------------------------------
//  バッファの template クラス
//
//  2021/07/19, Copyright (c) 2021 MIKAMI, Naoki
//-------------------------------------------------------

#ifndef INPUT_BUFFER_HPP
#define INPUT_BUFFER_HPP

#include "Array.hpp"
using namespace Mikami;

class InputBuffer
{
public:
    // コンストラクタ
    explicit InputBuffer(int size, float initValue = 0)
        : N_(size), buf_(2*size, initValue), index_(0), full_(false) {}
    
    // データを格納
    void Store(float data1, float data2)
    {
        buf_[index_] = data1;
        buf_[N_+index_++] = data2;
    }
    
    // バッファからデータの取り出し
    Array<float> Get() const { return buf_; }

    // バッファが満杯で次の準備を行う
    bool IsFullNext()
    {
        if (index_ < N_) return false;

        index_ = 0;
        full_ = true;
        return true;
    }

    // バッファが満杯で，true を返す
    bool IsFull()
    {
        bool temp = full_;
        if (full_) full_ = false;
        return temp;
    }

private:
    const int N_;       // バッファのサイズに対応する値
    Array<float> buf_;  // バッファ
    int index_;         // 入力データのカウンタ
    bool full_;         // 満杯の場合 true

    // コピー･コンストラクタおよび代入演算子の禁止のため
    InputBuffer(const InputBuffer&);
    InputBuffer& operator=(const InputBuffer&);
};
#endif  // INPUT_BUFFER_HPP