//---------------------------------------------------------
//	M 系列信号発生器（N = 16）
//
//	2021/09/28, Copyright (c) 2021 MIKAMI, Naoki
//---------------------------------------------------------

#include "mbed.h"

#ifndef MSEQ16_HPP
#define MSEQ16_HPP

namespace Mikami
{
	class MSeq16
	{
	public:
		MSeq16() : reg_(1) {}

		// 戻り値： 0 => -0.5, 1 => 0.5
		float Execute()
		{
			msb_ = reg_ >> 15;
			reg_ = ((reg_ ^ XOR_[msb_]) << 1) | msb_;
			return RET_[msb_];
		}
	private:
		static const uint16_t XOR_[2];	// XOR の一方の入力
		static const float RET_[2];		// 戻り値として使用
		uint16_t reg_;	// 16 段の D フリップ･フロップに対応
		uint16_t msb_;	// 16 段目に相当するビット
	};
	const uint16_t MSeq16::XOR_[2] = { 0, 0x16 };
	const float MSeq16::RET_[2] = { -0.5f, 0.5f };	
}
#endif	// MSEQ16_HPP