//-------------------------------------------------------
//  FFT を使ってスペクトル解析を行うクラス
//
//  2021/05/22, Copyright (c) 2021 MIKAMI, Naoki
//-------------------------------------------------------

#include "FFT_Analyzer.hpp"

namespace Mikami
{
    FftAnalyzer::FftAnalyzer(int nFft)
        : N_FFT_(nFft), fft_(nFft), wBlk_(nFft),
          xData_(nFft), wData_(nFft), yFft_(nFft/2+1) {}

    void FftAnalyzer::Execute(const Array<float> &xn, Array<float> &absFt)
    {
        xData_ = xn;    // データを作業領域にコピー

        // 直流分を除去
        float sum = 0;
        for (int n=0; n<N_FFT_; n++) sum = sum + xData_[n];
        float ave = sum/N_FFT_;
        for (int n=0; n<N_FFT_; n++) xData_[n] = xData_[n] - ave;

        wData_ = wBlk_.Execute(xData_); // 窓掛け
        fft_.Execute(wData_, yFft_);    // FFT の実行
        for (int n=0; n<=N_FFT_/2; n++) // 絶対値に変換
            absFt[n] = 100.0f*abs(yFft_[n]);
    }
}