//--------------------------------------------------------
//  ダブル･バッファの template クラス
//      バッファに２次元配列（Matrix クラス）を使用
//
//  2021/10/22, Copyright (c) 2021 MIKAMI, Naoki
//--------------------------------------------------------

#ifndef DOUBLE_BUFFER_HPP
#define DOUBLE_BUFFER_HPP

#include "Matrix.hpp"
using namespace Mikami;

class DoubleBuffer
{
public:
    // コンストラクタ
    explicit DoubleBuffer(int size, float initialValue = 0)
        : N_(size), buf_(2, size, initialValue), ping_(0), pong_(1),
          index_(0), full_(false) {}
    
    // データを格納
    void Store(float data)  { buf_[ping_][index_++] = data; }
    
    // 出力バッファからデータの取り出し
    float Get(int n) const { return buf_[pong_][n]; }

    // バッファが満杯でバッファを切り替える
    void IsFullSwitch()
    {
        if (index_ < N_) return;

        ping_ ^= 0x1;   // バッファ切換えのため
        pong_ ^= 0x1;   // バッファ切換えのため
        index_ = 0;
        full_ = true;
    }

    // バッファが満杯で，true を返す
    bool IsFull()
    {
        bool temp = full_;
        if (full_) full_ = false;
        return temp;
    }

private:
    const int N_;       // バッファのサイズ
    Matrix<float> buf_; // バッファ
    int ping_, pong_;   // バッファ切替用
    int index_;         // 入力データのカウンタ
    bool full_;         // 満杯の場合 true

    // コピー･コンストラクタおよび代入演算子の禁止のため
    DoubleBuffer(const DoubleBuffer&);
    DoubleBuffer& operator=(const DoubleBuffer&);
};
#endif  // DOUBLE_BUFFER_HPP