//-------------------------------------------------------------
//  Nucleo ボードの USB コネクタに対応するシリアルポート送信割込みで
//  キャラクタの送信をサポ－トするクラス
//
//  2020/02/05, Copyright (c) 2020 MIKAMI, Naoki
//-------------------------------------------------------------

#include "mbed.h"
#include <queue>
#include <string>

#ifndef SERIAL_TX_INTR_HPP
#define SERIAL_TX_INTR_HPP

namespace Mikami
{
    class SerialTxIntr
    {
    public:
        explicit SerialTxIntr(Serial &tx);  // コンストラクタ
        void TxChar(char c);        // １文字の送信
        void TxString(string str);  // 文字列の送信

    private:
        Serial &tx_;                // シリアルポートに対応するオブジェクトの参照
        queue<char> que_;           // FIFO による送信用バッファ
        USART_TypeDef* const USART_;

        // TDR へ書込み
        void WriteTDR(char ch) { USART_->DR = ch; }
        // 送信割込み許可
        void EnableTxIntr() { USART_->CR1 |= USART_CR1_TXEIE; }
        // 送信割込み禁止
        void DisableTxIntr() { USART_->CR1 &= ~USART_CR1_TXEIE; }
        // TDR が空の場合に true を返す
        bool IsTdrEmpty()
        { return (USART_->SR && USART_SR_TXE_Msk) == USART_SR_TXE; }

        void TxIsr();   // シリアルポート送信割込みサービスルーチン

        // コピー･コンストラクタ，代入演算子の禁止のため
        SerialTxIntr(const SerialTxIntr&);
        SerialTxIntr& operator=(const SerialTxIntr&);
    };
}
#endif  // SERIAL_TX_INTR_HPP