//-------------------------------------------------------------
//  Nucleo ボードの USB コネクタに対応するシリアルポート送信割込みで
//  キャラクタの送信をサポ－トするクラス
//
//  2020/02/05, Copyright (c) 2020 MIKAMI, Naoki
//-------------------------------------------------------------

#include "SerialTxIntr.hpp"

namespace Mikami
{
    // コンストラクタ
    SerialTxIntr::SerialTxIntr(Serial &tx) : tx_(tx), USART_(USART2)
    {
        tx_.attach(callback(this, &SerialTxIntr::TxIsr), Serial::TxIrq);
    }
    
    // １文字の送信
    void SerialTxIntr::TxChar(char c)
    {
        DisableTxIntr();                    // 送信割込み禁止

        // 送信レジスタ (TDR) が空でかつ送信バッファが空かどうか調べる
        if ( que_.empty() && IsTdrEmpty() ) // 両者が空の場合
            WriteTDR(c);                    // 送信レジスタにデータを書き込む
        else                                // 少なくとも一方が空ではない場合
            que_.push(c);                   // 送信バッファにデータを格納

        EnableTxIntr();                     // 送信割込み許可
    }

    // 文字列の送信
    void SerialTxIntr::TxString(string str)
    {
        for (int n=0; n<str.size(); n++) TxChar(str[n]);
    }
    
    // シリアルポート送信割込みサービスルーチン
    void SerialTxIntr::TxIsr()
    {
        if (!que_.empty())
        {
            WriteTDR(que_.front()); // 送信用バッファから取り出したデータを TDR へ書き込む
            que_.pop();             // 先頭のデータを消去
        }
        else
            DisableTxIntr();        // 送信割込み禁止
    }
}