//--------------------------------------------------------------
//  SD_WavReader class ---- Header
//      SD カードの *.wav ファイルの内容を読み出す
//      以下の型式のファイルのみ扱う
//          PCM，16 ビットステレオ，標本化周波数 44.1 kHz
//
//  2017/03/22, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef SD_WAV_READER_HPP
#define SD_WAV_READER_HPP

#include "stm32746g_discovery_audio.h"
#include "SDFileSystem.h"
#include "BlinkLabel.hpp"
#include "Array.hpp"
#include <string>

namespace Mikami
{
    class SD_WavReader
    {
    public:
        SD_WavReader(int32_t bufferSize);
        virtual ~SD_WavReader();

        void Open(const string fileName);
        
        void Close() { fclose(fp_); }
        
        // ファイルのヘッダ読み込み
        bool IsWavFile();

        // ファイルからステレオデータの取得
        void ReadStereo(Array<int16_t>& dataL, Array<int16_t>& dataR);

        // ファイルからデータをモノラルに変換しての取得
        void ReadAndToMono(Array<int16_t>& data);
        
        // データサイズ（標本化点の数）の取得
        int32_t GetSize();

    private:
        const string STR_;
        
        struct WaveFormatEx
        {
            uint16_t wFormatTag;        // 1: PCM
            uint16_t nChannels;         // 1：モノラル，2: ステレオ
            uint32_t nSamplesPerSec;    // 標本化周波数 (Hz)
            uint32_t nAvgBytesPerSec;   // 転送速度 (bytes/s)
            uint16_t nBlockAlign;       // 4: 16ビットステレオの場合
            uint16_t wBitsPerSample;    // データのビット数，8 または 16
            uint16_t cbSize;            // PCM の場合使わない
        };

        SDFileSystem *sd_;
        FILE *fp_;
        
        bool ok_;
        int32_t size_;          // データサイズ（標本化点の数）
        Array<int16_t> buffer;  // 作業領域
        
        void ErrorMsg(char msg[])
        {   BlinkLabel errLabel(240, 100, msg, Label::CENTER); }

        // コピー･コンストラクタとオブジェクトの代入演算子は使用禁止
        SD_WavReader(const SD_WavReader&);
        SD_WavReader& operator=(const SD_WavReader&);
    };
}
#endif  // SD_BINARY_READER_HPP
