//--------------------------------------------------------------
//  SD プレーヤー用抽象基底クラス（ヘッダ）
//
//  2017/03/22, Copyright (c) 2016 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef F746_SD_PLAYER_SKELETON_HPP
#define F746_SD_PLAYER_SKELETON_HPP

#include "SAI_InOut.hpp"
#include "F746_GUI.hpp"
#include "FileSelectorWav.hpp"
#include "SD_WavReader.hpp"

using namespace Mikami;

namespace Mikami
{
    class SD_PlayerSkeleton
    {
    public:
        // リセット･ボタンを使う場合は resetButton を true とする
        SD_PlayerSkeleton(string str, bool resetButton = false);
        virtual ~SD_PlayerSkeleton() { if (reset_ != NULL) delete reset_; }
        // SD プレーヤーの処理の実行
        void Execute();

    protected:
        // ボタン用の定数
        static const uint16_t BG_LEFT_ = 414;
        static const uint16_t BG_WIDTH_ = 66;
        static const uint16_t BG_HEIGHT_ = 36;
    
        const int32_t BUFF_SIZE_;   // バッファのサイズ
        Array<int16_t> sn_;         // バッファ

        SaiIO mySai_;
        SD_WavReader sdReader_; // SD カード読み込み用オブジェクト

        // 選択されたファイル名を取得
        string GetFileName() { return fileName_; }
        // 選択されたファイル名から拡張子を除いたものを取得
        string GetFileNameNoExt();

    private:
        string fileName_;       // 選択されたファイル名
        Label title_;           // 上部に表示されるタイトル
        FileSelector selector_;
        ButtonGroup menu_;
        ResetButton *reset_;    // リセットボタン用オブジェクトのポインタ

        // SD カードのファイルのオープン
        int32_t SD_Open();
        // ファイルの選択
        void SelectFile();
        // パネルが操作された場合の処理
        void DoIfHandled();

        // メニューのいずれかのボタンがタッチされるまで DoIfHandled() を実行しながら待つ
        int WaitTouched();

        // コピー･コンストラクタとオブジェクトの代入演算子は使用禁止
        SD_PlayerSkeleton(const SD_PlayerSkeleton&);
        SD_PlayerSkeleton& operator=(const SD_PlayerSkeleton&);

        //-------------------------------------
        //      以下は仮想関数
        //-------------------------------------
        // １ブロック分の信号処理
        virtual void SignalProcessing() = 0;
        // 信号処理のパラメータ変更など
        virtual void Modefy() {}
        // 曲の再生時の表示
        virtual void Display() {}
        // 信号処理で必要になるクリア処理
        virtual void Clear() {}
    };
}
#endif  // F746_SD_PLAYER_SKELETON_HPP
