//--------------------------------------------------------------
//  IIR フィルタを利用する正弦波発生器のクラス
//
//  2020/08/10, Copyright (c) 2020 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"

#ifndef SIN_OSC_IIR_HPP
#define SIN_OSC_IIR_HPP

namespace Mikami
{
    class SinOscIir
    {
    public:
        // コンストラクタ
        //      f0  周波数，単位：Hz
        //      ts  標本化間隔，単位：μs
        SinOscIir(float f0, float ts)
        {
            static const float PI2 = 6.283185f;
            float pi2F0Ts = PI2*f0*ts*1.0E-6f;
            a1_ = 2.0f*cosf(pi2F0Ts);
            b1_ = sinf(pi2F0Ts);
            vn1_ = 1.0f;
            vn2_ = 0.0f;
        }

        // sin 発生
        float Generate()
        {
            float vn = a1_*vn1_ - vn2_;

            vn2_ = vn1_;    // v[n-2] ← v[n-1]
            vn1_ = vn;      // v[n-1] ← v[n]
            
            return b1_*vn2_;
        }

    private:
        float a1_, b1_;
        float vn1_, vn2_;

        // コピー･コンストラクタ，代入演算子の禁止のため
        SinOscIir(const SinOscIir&);
        SinOscIir& operator=(const SinOscIir&);
    };
}
#endif  // SIN_OSC_IIR_HPP