//--------------------------------------------------------------
//  高速低精度 sin 計算
//      sin(πx/2), -2< = x <= 2 を計算する
//      誤差の絶対値の最大値：6.7706E-5
//
//      係数はミニマックス近似で求めたもの．ただし，誤差は絶対誤差で評価した
//
//  2020/08/11, Copyright (c) 2020 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"

#ifndef FAST_SINE_LOW_PRECISION_HPP
#define FAST_SINE_LOW_PRECISION_HPP

namespace Mikami
{
    float FastSin(float x)
    {
        static const float A1 =  1.57032033f;
        static const float A3 = -0.64211427f;
        static const float A5 =  0.07186159f;
        
        x = (x >  1.0f) ?  2.0f - x : x;
        x = (x < -1.0f) ? -2.0f - x : x;

        float x2 = x*x;
        float sinx = ((A5*x2 + A3)*x2 + A1)*x;
        
        return sinx;
    }
}
#endif  // FAST_SINE_LOW_PRECISION_HPP