//-----------------------------------------------------------------
// FM 変調器
//
//  2020/08/29, Copyright (c) 2020 MIKAMI, Naoki
//-----------------------------------------------------------------

#include "mbed.h"
#include "FastSin.hpp"          // 高速低精度 sin 計算

#ifndef FM_MODULATOR_HPP
#define FM_MODULATOR_HPP

namespace Mikami
{
    class FmModulator
    {
    public:
        // コンストラクタ
        //      fCarrier    搬送波周波数 [Hz]
        //      t0          標本化間隔 [μs]
        FmModulator(float fCarrier, float t0)
            : C0_(4.0f*fCarrier*t0*1.0e-6f), phi_(0) {}

        // FM 変調の実行
        float Execute(float mod)
        {
            phi_ += C0_ + mod;              // ここで FM 変調を行っている
            if (phi_ > 2.0f) phi_ -= 4.0f;
            return FastSin(phi_);
        }

    private:
        const float C0_;    // 搬送波周波数に対応する位相の増分
        float phi_;         // 現在の位相

        // コピー･コンストラクタ，代入演算子禁止のため
        FmModulator(const FmModulator&);
        FmModulator& operator=(const FmModulator&);
    };
}
#endif  // FM_MODULATOR_HPP