//-----------------------------------------------------------------
// 一次の IIR フィルタ
//      y[n] = a1*y[n-1] + (1 - a1)*x[n]
//
// 2020/08/05, Copyright (c) 2020 MIKAMI, Naoki
//-----------------------------------------------------------------

#include "mbed.h"

#ifndef IIR_1ST_HPP
#define IIR_1ST_HPP
namespace Mikami
{
    class Iir1st
    {
    public:
        // コンストラクタ
        //      a1  フィルタの係数
        Iir1st(float a1) : A1_(a1), B0_(1.0f - a1), yn_(0) {}

        // フィルタの実行
        float Execute(float xn)
        {
            yn_ = A1_*yn_ + B0_*xn;
            return yn_;
        }

    private:
        const float A1_;    // フィルタ係数
        const float B0_;    // フィルタ係数
        float yn_;          // 出力

        // コピー･コンストラクタ，代入演算子の禁止のため
        Iir1st(const Iir1st&);
        Iir1st& operator=(const Iir1st&);
    };
}
#endif  // IIR_1ST_HPP