//-----------------------------------------------------------------
// 直流分除去用 IIR フィルタ
//      u[n] = a1*u[n-1] + x[n]
//      y[n] = g0*(u[n] - u[n-1])
//
// 2020/08/17, Copyright (c) 2020 MIKAMI, Naoki
//-----------------------------------------------------------------

#include "mbed.h"

#ifndef IIR_DC_CUT_HPP
#define IIR_DC_CUT_HPP
namespace Mikami
{
    class IirDcCut
    {
    public:
        // コンストラクタ
        //      a1  フィルタの係数
        //      g0  利得定数
        IirDcCut(float a1, float g0)
            : A1_(a1), G0_(g0), un1_(0) {}

        // フィルタの実行
        float Execute(float xn)
        {
            float un = A1_*un1_ + xn;
            float yn = (un - un1_)*G0_;
            un1_ = un;
            return yn;
        }

    private:
        const float A1_;        // フィルタ係数
        const float G0_;        // 利得定数
        float un1_;             // 遅延器の値

        // コピー･コンストラクタ，代入演算子の禁止のため
        IirDcCut(const IirDcCut&);
        IirDcCut& operator=(const IirDcCut&);
    };
}
#endif  // IIR_DC_CUT_HPP