//--------------------------------------------------------
//  STM32F446 内蔵の DAC 用のクラス
//      出力端子：   A2 (PA_4) に固定
//
//  2020/07/23, Copyright (c) 2020 MIKAMI, Naoki
//--------------------------------------------------------

#include "F446_DAC.hpp"
#include "pinmap.h"         // pin_function() で使用

namespace Mikami
{
    // コンストラクタ
    DacF446::DacF446() : DAC_(DAC)
    {
        // A2 に対応する GPIOx_MODER をアナログ･モードに設定する
        pin_function(A2, STM_MODE_ANALOG);

        __HAL_RCC_DAC_CLK_ENABLE(); // DAC にクロックを供給する
        // __HAL_RCC_DAC_CLK_ENABLE() の定義：stm32f4xx_hal_rcc_ex.h
        
        DAC_->CR = DAC_CR_EN1;      // DAC を有効にする
    }
}