//-------------------------------------------------------------
//  ダウンサンプリングで使う3段の CIC フィルタ用クラス
//
//  2020/08/02, Copyright (c) 2020 MIKAMI, Naoki
//-------------------------------------------------------------

#include "mbed.h"

#ifndef CIC3_FILTER_CLASS_HPP
#define CIC3_FILTER_CLASS_HPP

namespace Mikami
{
    class Cic3Stage
    {
    public:
        // コンストラクタ
        //      rate ダウンサンプリングの率，1/10 にダウンサンプリングする場合は 10
        //      amp  直交信号発生器の出力の振幅
        Cic3Stage(int rate, float amp)
            : G0_(1.0f/(amp*rate*rate*rate)), 
              vn1_(0), vn2_(0), vn3_(0), vn3M1_(0), yn1M1_(0), yn2M1_(0) {}
        
        // 積分器
        void Integrate(int16_t xn)
        {
            vn1_ += xn;     // 積分器1段目
            vn2_ += vn1_;   // 積分器2段目
            vn3_ += vn2_;   // 積分器3段目
        }

        // くし形フィルタ
        float CombFilter()
        {
            int32_t yn1 = vn3_ - vn3M1_;    // くし形フィルタ1段目
            int32_t yn2 = yn1 - yn1M1_;     // くし形フィルタ2段目
            int32_t yn3 = yn2 - yn2M1_;     // くし形フィルタ3段目

            vn3M1_ = vn3_;  // 現在の値を保存，くし形フィルタ1段目
            yn1M1_ = yn1;   // 現在の値を保存，くし形フィルタ2段目
            yn2M1_ = yn2;   // 現在の値を保存，くし形フィルタ3段目

            return G0_*yn3;
        }

    private:
        const float G0_;
        int32_t vn1_, vn2_, vn3_;       // 積分器で使う変数
        int32_t vn3M1_, yn1M1_, yn2M1_; // くし形フィルタで使う変数

        // コピー･コンストラクタ，代入演算子の禁止のため
        Cic3Stage(const Cic3Stage&);
        Cic3Stage& operator=(const Cic3Stage&);
    };
}
#endif  // CIC3_FILTER_CLASS_HPP