//-------------------------------------------------------------
//  F446 内蔵 ADC を割込み方式で使うための派生クラス
//      基底クラス： AdcF446_Base
//
//  2020/07/24, Copyright (c) 2020 MIKAMI, Naoki
//-------------------------------------------------------------

#include "F446_ADC_Base.hpp"

#ifndef ADC_F446_INTERRUPT_HPP
#define ADC_F446_INTERRUPT_HPP

namespace Mikami
{
    class AdcF446_Intr : public AdcF446_Base
    {
    public:
        // コンストラクタ
        //      fSampling   標本化周波数 [kHz]
        //      pin       入力ピンの名前
        AdcF446_Intr(float fSampling, PinName pin)
            : AdcF446_Base(fSampling, pin)
        {   myAdc_->CR1 |= ADC_CR1_EOCIE; }     // AD 変換終了割り込みを許可

        virtual ~AdcF446_Intr() {}

        // 割込みベクタの設定と AD 変換割込みを有効にする
        void SetIntrVec(void (*Func)())
        {
            NVIC_SetVector(ADC_IRQn, (uint32_t)Func);   // "core_cm4.h" 参照
            NVIC_EnableIRQ(ADC_IRQn);                   // "core_cm4.h" 参照
        }    

        // AD 変換された値を読み込む
        //      -1.0f <= AD変換された値 < 1.0f
        virtual float Read() { return ToFloat(myAdc_->DR); }

    private:
        // コピー･コンストラクタ，代入演算子禁止の禁止のため
        AdcF446_Intr(const AdcF446_Intr&);
        AdcF446_Intr& operator=(const AdcF446_Intr&);
    };
}
#endif  // ADC_F446_INTERRUPT_HPP