//---------------------------------------------------------
// 線形合同法による一様乱数を使い，中心極限定理を利用する正規乱数発生
//      ＜文献＞
//      三上直樹：「アルゴリズム教科書」，第11章，CQ出版，1996年．
// 
//  2018/06/25, Copyright (c) 2018 MIKAMI, Naoki
//---------------------------------------------------------

#include "Random.hpp"

namespace Mikami
{
    class GaussRand
    {
    public:
        // sigma  標準偏差
        // av     平均値
        // x      乱数の種
        GaussRand(float sigma, float av, uint32_t x = 901253)
            : sigma_(sigma), av_(av), rd_(x) {}
       
        // 中心極限定理を利用する正規乱数発生
        float Next()
        {
            float gauss = 0;
            for (int n=0; n<12; n++) gauss += rd_.Next();
            return sigma_*(gauss - 6.0f) + av_;
        }
        
    private:
        float sigma_;
        float av_;
        Random rd_;
    };    
}
