//-------------------------------------------------------------
// 線形合同法による一様乱数発生
//      ＜文献＞
//      三上直樹：「アルゴリズム教科書」，第11章，CQ出版，1996年．
//      float 型のビット配置が IEEE の浮動小数点数と同じ場合にのみ有効
//
//  2018/02/15, Copyright (c) 2018 MIKAMI, Naoki
//-------------------------------------------------------------

#include "mbed.h"

namespace Mikami
{
    class Random
    {
    public:
        Random() : seed_(901253) {}
        Random(uint32_t x) : seed_(x) {}

        // 0 以上 1 未満の一様乱数生成
        float Next()
        {
            seed_ = 1664525*seed_ + 1013904223;
            var.usl = seed_ >> 9;   // 指数部を 0 にする
            var.usl |= 0x3f800000;  // 指数部： 1～2 の値に対応
            return var.flt - 1.0f;
        }
        
    private:
        uint32_t seed_;     // 乱数の種
        union bit32w { uint32_t usl; float flt; } var;
    };    
}

