//----------------------------------------------------------------
//  InterruptIn, Timeout を利用してチャタリングを防止するクラス
//      割込みサービス･ルーチンは非 static 関数にしている
//
//  2019/03/22, Copyright (c) 2019 MIKAMI, Naoki
//----------------------------------------------------------------

#include "PushButton.hpp"

using namespace Mikami;

// コンストラクタ
PushButton::PushButton(PinName pin, PinMode mode, RiseFall rf,
                        void (*Func)(), float time)
    : pbSw_(InterruptIn(pin, mode)), fp_(Func), time_(time)
{
    if (rf == RISE)
        pbSw_.rise(callback(this, &PushButton::IsrIntrIn));
    else
        pbSw_.fall(callback(this, &PushButton::IsrIntrIn));
}
            
// InterruptIn の割込みサービス･ルーチン
void PushButton::IsrIntrIn()
{
    pbSw_.disable_irq();
    enabler_.attach(callback(this, &PushButton::IsrTimeout), time_);
    fp_();      // コンストラクタの引数で与えられた関数が実行される
}

// Timeout の割込みサービス･ルーチン
void PushButton::IsrTimeout()
{
    pbSw_.enable_irq();
}