//------------------------------------------------------------------------
//  InterruptIn, Timeout を利用してチャタリングを防止するクラス，ヘッダ
//      割込みサービス･ルーチンは非 static 関数にしている
//
//  2020/04/21, Copyright (c) 2020 MIKAMI, Naoki
//------------------------------------------------------------------------

#include "mbed.h"

#ifndef PUSHBUTTON_CLASS_HPP
#define PUSHBUTTON_CLASS_HPP

namespace Mikami
{
    class PushButton
    {
    public:
        enum RiseFall { RISE, FALL };

        // コンストラクタ
        PushButton(PinName pin,         // 入力のピン
                   PinMode mode,        // "PullUp", "PullDown" などを指定
                   RiseFall rf,         // 割込み発生が立ち上りか立ち下りかを指定
                   void (*Func)(),      // 割込みサービス･ルーチン
                   float time = 0.1);   // 入力を禁止する時間

    private:
        InterruptIn pbSw_;  // Mbed オフィシャル･ライブラリのクラスのオブジェクト
        Timeout enabler_;   // Mbed オフィシャル･ライブラリのクラスのオブジェクト
        void (*fp_)();      // コンストラクタの引数で与えられた関数に対応するポインタ
        float time_;        // InterruptIn 割込みを無効にしている時間
            
        // InterruptIn の割込みサービス･ルーチン
        void IsrIntrIn();

        // Timeout の割込みサービス･ルーチン
        void IsrTimeout();

        // コピー･コンストラクタおよび代入演算子の禁止のため
        PushButton(const PushButton& );
        PushButton& operator=(const PushButton& );
    };
}
#endif  // PUSHBUTTON_CLASS_HPP