//--------------------------------------------------------------
// Frequency converter system class
// Copyright (c) 2014 MIKAMI, Naoki,  2014/07/20
//--------------------------------------------------------------

#ifndef FREQUENCYCONVERTER_HPP
#define FREQUENCYCONVERTER_HPP

#include "mbed.h"
#include "HilbertTransform.hpp"
#include "coefsHilbert94.hpp"
#include "DC_Cut_Coefficients.hpp"
#include "TwoPhaseGenerator.hpp"

namespace Mikami
{
    class FrqConvSystem
    {
    private:
        Hilbert<ORDER_> ht_;
        Biquad DcCut_;      // DC cut filter
        TwoPhaseGenerator sinCos_; // 100.0 Hz
    public:
        FrqConvSystem(float fC, float fS)
            : ht_(hm_), DcCut_(cDccut_), sinCos_(fC, fS) {}
        float Execute(float x)
        {
            float yI, yQ, cosx, sinx;

            float xn = x;
            xn = DcCut_.Execute(gDccut_*x); // DC cut
            ht_.Execute(xn, yI, yQ);        // Hilbert transform
            sinCos_.Generate(cosx, sinx);   // cos and sin generator
            float yn = yI*cosx - yQ*sinx;   // conversion
            return yn;
       };
    };
}
#endif  //  FREQUENCYCONVERTER_HPP

