//--------------------------------------------------------------
// Frequency converter for Open Campus
// Copyright (c) 2015 MIKAMI, Naoki,  2015/08/09
//--------------------------------------------------------------

#include "mbed.h"
#include "AdcInternal.hpp"
#include "MCP4921.hpp"
#include "FrequencyConverter.hpp"

using namespace Mikami;

const float FS_ = 10.0e3f;
Adc adc_(A0);
DacMCP4921 dac_;

Ticker timer_;          // for timer interrupt

//**********************************************//
//  Change parameters, "100.0f", ex. "-100.0f"
FrqConvSystem myFrqConv_(100.0f, FS_);
//**********************************************//

void TimerIsr()
{
    float xn = adc_.Read(); // input
    float yn = myFrqConv_.Execute(xn);
    dac_.Write(yn);         // output
}

int main()
{
    timer_.attach_us(&TimerIsr, 1.0e6f/FS_);
    while (true) {}    // infinite loop
}

