//------------------------------------------------------
// Class for DAC, MCP4921
//
// Default pin assign
//      D11  SPI Master Out Slave In
//      D13  SPI Serial Clock
//      D10  SPL Slave Select
//
// 2014/07/29, Copyright (c) 2014 MIKAMI, Naoki
//------------------------------------------------------

#ifndef MCP4921_HPP
#define MCP4921_HPP

#include "mbed.h"

namespace Mikami
{
    class DacMCP4921
    {
    public:
        // Constructor
        DacMCP4921(PinName mosi = SPI_MOSI,  // D11, pin4
                   PinName sclk = SPI_SCK,   // D13, pin3
                   PinName cs   = SPI_CS,    // D10, pin2
                   int hz = 20000000);

        // -1.0f <= value <= 1.0f
        void Write(float value);
        // 0 <= value <= 4095
        void Write(uint16_t value);
        // generate LDAC pulse for dual DAC
        void Ldac();

    private:
        SPI mySpi_;       // SPI object
        DigitalOut myCs_; // for chip select

        // for use internally
        void WriteDac(uint16_t value);
    };
}
#endif  // MCP4921_HPP
