//------------------------------------------------------
// Class for DAC in MCP4921
//
// 2014/07/29, Copyright (c) 2014 MIKAMI, Naoki
//------------------------------------------------------

#include "MCP4921.hpp"

namespace Mikami
{
    DacMCP4921::DacMCP4921(PinName mosi, PinName sclk,
                           PinName cs, int hz)
        : mySpi_(mosi, NC, sclk, PA_4), myCs_(cs, 1)
    {
        // Set SPI format and bus frequency
        mySpi_.format(16, 0);
        mySpi_.frequency(hz);

        // Set DAC to 0
        WriteDac(0);
    }

    void DacMCP4921::Write(float value)
    {
        if (value < -1.0f) value = -1.0f;
        if (value >  1.0f) value =  1.0f;

        WriteDac((uint16_t)((value + 1.0f)*2047));
    }

    void DacMCP4921::Write(uint16_t value)
    {
        WriteDac((value > 4095) ? 4095 : value);
    }

    void DacMCP4921::WriteDac(uint16_t value)
    {
        myCs_.write(0); // cs <= L
        mySpi_.write(value | 0x3000);
        myCs_.write(1); // cs <= H
    }
}

