//------------------------------------------------------
// Class for internal ADC for signal processing
//
// Copyright (c) 2014 MIKAMI, Naoki,  2014/06/17
//------------------------------------------------------

#ifndef ADC_INTERNAL_HPP
#define ADC_INTERNAL_HPP

#include "mbed.h"

namespace Mikami
{
    class Adc
    {
    public:
        explicit Adc(PinName pin = A0)
                    : adc_(pin) {}
        float Read()
            { return 2*(adc_.read() - 0.5f); }
    private:
        Adc(const Adc&);
        Adc& operator=(const Adc&);
        AnalogIn adc_;
    };
}
#endif  // ADC_INTERNAL_HPP
