//--------------------------------------------------------------
// Echo generation system class
// Copyright (c) 2014 MIKAMI, Naoki,  2014/07/29
//--------------------------------------------------------------

#ifndef REVERBSYSTEM_UNIT_HPP
#define REVERBSYSTEM_UNIT_HPP

#include "mbed.h"
#include "ReverbUnit.hpp"

namespace Mikami
{
    class ReverbSystem
    {
    public:
        ReverbSystem()
            : GC_(0.8f), GA_(0.6f), G0_(GC_-GA_),
              cmF1(GC_), cmF2(GC_), cmF3(GC_),
              apF1(GA_), apF2(GA_) {}
        
        float Execute(float x)
        {
            float xn = G0_*x;
            float yn = cmF1.Execute(xn) + cmF2.Execute(xn)
                     + cmF3.Execute(xn);
            yn = apF2.Execute(apF1.Execute(yn));
            yn = yn + xn;   // add direct input signal
            return yn;
        }
        
    private:
        const float GC_, GA_, G0_;
        CombFilter<887>    cmF1;
        CombFilter<1153>   cmF2;
        CombFilter<1499>   cmF3;
        AllPassFilter<97>  apF1;
        AllPassFilter<131> apF2;
    };   
}
#endif  // REVERBSYSTEM_UNIT_HPP
