//-----------------------------------------------------------
// タイマを使った正確な同期の実現, TIM7 を使用
//
//  2020/10/16, Copyright (c) 2020 MIKAMI, Naoki
//-----------------------------------------------------------

#include "mbed.h"

#ifndef MYTICKER7_HPP
#define MYTICKER7_HPP

namespace Mikami
{
    class MyTicker7
    {
    public:
        // コンストラクタ
        //      period  時間間隔 [μs]
        explicit MyTicker7(float period);

        // コンストラクタで設定した時間が経過するまで待つ
        void Sync();

        // クラス内 ISR で実行する関数の割当て，割込みを有効にする
        void Attach(void (*Func)());

        // 割込みを無効にする
        void Disable() { MY_TIM_->DIER &= ~TIM_DIER_UIE; }
        // 割込みを有効にする
        void Enable() { MY_TIM_->DIER |= TIM_DIER_UIE; }

    private:
        static TIM_TypeDef* const MY_TIM_;
        static void (*fp)();    // 割込みサービス･ルーチンの中で実行される関数のポインタ
        static void Isr();      // カラス内の割込みサービス･ルーチン
        static bool created_;   // オブジェクトの多重生成禁止のため

        // コピー･コンストラクタ，代入演算子の禁止のため
        MyTicker7(const MyTicker7&);
        MyTicker7& operator=(const MyTicker7&);
    };
}
#endif  // MYTICKER7_HPP