//------------------------------------------------------------------
//  InterruptIn, Timeout を利用してチャタリングを防止するクラス，ヘッダ
//      割込みサービス･ルーチンは非 static 関数にしている
//
//  2020/02/16, Copyright (c) 2020 MIKAMI, Naoki
//------------------------------------------------------------------

#include "mbed.h"

#ifndef PUSHBUTTON_CLASS_HPP
#define PUSHBUTTON_CLASS_HPP

namespace Mikami
{
    class PushButton
    {
    public:
        enum RiseFall { RISE, FALL };

        // コンストラクタ
        PushButton(PinName pin, PinMode mode, RiseFall rf, void (*Func)(),
                   float time = 0.1);

    private:
        InterruptIn pbSw_;  // Mbed オフィシャル･ライブラリのクラスのオブジェクト
        Timeout enabler_;   // Mbed オフィシャル･ライブラリのクラスのオブジェクト
        void (*fp_)();      // コンストラクタの引数で与えられた関数に対応するポインタ
        float time_;        // InterruptIn 割込みを無効にしている時間
            
        // InterruptIn の割込みサービス･ルーチン
        void IsrIntrIn();

        // Timeout の割込みサービス･ルーチン
        void IsrTimeout();

        // コピー･コンストラクタおよび代入演算子の禁止のため
        PushButton(const PushButton& );
        PushButton& operator=(const PushButton& );
    };
}
#endif  // PUSHBUTTON_CLASS_HPP

